from __future__ import annotations

from cothinker.engine import CoThinkerConfig


def get_config(name: str) -> CoThinkerConfig:
    name = name.lower()
    if name in ("io", "zero-shot"):
        return CoThinkerConfig(num_agents=1, num_rounds=1, enable_style_generator=False, summarizer="none")
    if name in ("cot", "chain-of-thought"):
        return CoThinkerConfig(num_agents=1, num_rounds=1, enable_style_generator=True, summarizer="none")
    if name in ("sr", "self-refine"):
        return CoThinkerConfig(num_agents=1, num_rounds=2, enable_style_generator=False, summarizer="individual")
    if name in ("mad",):
        return CoThinkerConfig(num_agents=3, num_rounds=2, enable_style_generator=False, summarizer="tms")
    if name in ("dmad",):
        return CoThinkerConfig(num_agents=6, num_rounds=3, enable_style_generator=True, summarizer="tms")
    if name in ("sw_mas", "small-world-mas"):
        return CoThinkerConfig(num_agents=6, num_rounds=3, enable_style_generator=True, summarizer="tms")
    # default
    return CoThinkerConfig()
